/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.SmartIdentityTable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "<init>", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerForMethod", "backend"})
public final class LabelNormalizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        new TransformerForMethod(methodNode).transform();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00182\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002J\f\u0010(\u001a\u00020\u0018*\u00020\u001aH\u0002J\f\u0010(\u001a\u00020\u0018*\u00020\u001dH\u0002J\f\u0010(\u001a\u00020\u0018*\u00020 H\u0002J\f\u0010(\u001a\u00020\u0018*\u00020\"H\u0002J\f\u0010(\u001a\u00020\u0018*\u00020%H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "newLabelNodes", "Lorg/jetbrains/kotlin/utils/SmartIdentityTable;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getNewLabelNodes", "()Lorg/jetbrains/kotlin/utils/SmartIdentityTable;", "transform", "", "rewriteLabelInstructions", "", "rewriteNonLabelInstructions", "rewriteLineNumberNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "oldLineNode", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "rewriteJumpInsn", "oldJumpNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "rewriteLookupSwitchInsn", "oldSwitchNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "rewriteTableSwitchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "rewriteFrameNode", "oldFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/FrameNode;", "rewriteTryCatchBlocks", "rewriteLocalVars", "rewriteLabels", "getNew", "oldLabelNode", "getNewOrOld", "backend"})
    @SourceDebugExtension(value={"SMAP\nLabelNormalizationMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelNormalizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1586#2:168\n1661#2,3:169\n1586#2:172\n1661#2,3:173\n1586#2:176\n1661#2,3:177\n1586#2:180\n1661#2,3:181\n1586#2:184\n1661#2,3:185\n1586#2:188\n1661#2,3:189\n*S KotlinDebug\n*F\n+ 1 LabelNormalizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod\n*L\n101#1:168\n101#1:169,3\n110#1:172\n110#1:173,3\n130#1:176\n130#1:177,3\n136#1:180\n136#1:181,3\n142#1:184\n142#1:185,3\n143#1:188\n143#1:189,3\n*E\n"})
    private static final class TransformerForMethod {
        @NotNull
        private final MethodNode methodNode;
        private final InsnList instructions;
        @NotNull
        private final SmartIdentityTable<LabelNode, LabelNode> newLabelNodes;

        public TransformerForMethod(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter(methodNode, "methodNode");
            this.methodNode = methodNode;
            this.instructions = this.methodNode.instructions;
            this.newLabelNodes = new SmartIdentityTable();
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final InsnList getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final SmartIdentityTable<LabelNode, LabelNode> getNewLabelNodes() {
            return this.newLabelNodes;
        }

        public final void transform() {
            if (this.rewriteLabelInstructions()) {
                this.rewriteNonLabelInstructions();
                this.rewriteTryCatchBlocks();
                this.rewriteLocalVars();
                UtilKt.removeEmptyCatchBlocks(this.methodNode);
            }
        }

        private final boolean rewriteLabelInstructions() {
            boolean removedAnyLabels = false;
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                if (thisNode instanceof LabelNode) {
                    AbstractInsnNode prevNode = ((LabelNode)thisNode).getPrevious();
                    if (prevNode instanceof LabelNode) {
                        this.newLabelNodes.set((LabelNode)thisNode, (LabelNode)prevNode);
                        removedAnyLabels = true;
                        InsnList insnList = this.instructions;
                        Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
                        thisNode = LabelNormalizationMethodTransformerKt.removeNodeGetNext(insnList, thisNode);
                        continue;
                    }
                    this.newLabelNodes.set((LabelNode)thisNode, (LabelNode)thisNode);
                    thisNode = ((LabelNode)thisNode).getNext();
                    continue;
                }
                thisNode = thisNode.getNext();
            }
            return removedAnyLabels;
        }

        private final void rewriteNonLabelInstructions() {
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                AbstractInsnNode abstractInsnNode = thisNode;
                thisNode = abstractInsnNode instanceof JumpInsnNode ? this.rewriteJumpInsn((JumpInsnNode)thisNode) : (abstractInsnNode instanceof LineNumberNode ? this.rewriteLineNumberNode((LineNumberNode)thisNode) : (abstractInsnNode instanceof LookupSwitchInsnNode ? this.rewriteLookupSwitchInsn((LookupSwitchInsnNode)thisNode) : (abstractInsnNode instanceof TableSwitchInsnNode ? this.rewriteTableSwitchInsn((TableSwitchInsnNode)thisNode) : (abstractInsnNode instanceof FrameNode ? this.rewriteFrameNode((FrameNode)thisNode) : thisNode.getNext()))));
            }
        }

        private final AbstractInsnNode rewriteLineNumberNode(LineNumberNode oldLineNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, oldLineNode, this.rewriteLabels(oldLineNode));
        }

        private final AbstractInsnNode rewriteJumpInsn(JumpInsnNode oldJumpNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, oldJumpNode, this.rewriteLabels(oldJumpNode));
        }

        private final AbstractInsnNode rewriteLookupSwitchInsn(LookupSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteTableSwitchInsn(TableSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteFrameNode(FrameNode oldFrameNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, oldFrameNode, this.rewriteLabels(oldFrameNode));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteTryCatchBlocks() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<TryCatchBlockNode> list = this.methodNode.tryCatchBlocks;
            Intrinsics.checkNotNullExpressionValue(list, "tryCatchBlocks");
            Iterable iterable = list;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldTcb;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LabelNode labelNode = oldTcb.start;
                Intrinsics.checkNotNullExpressionValue(labelNode, "start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldTcb.end;
                Intrinsics.checkNotNullExpressionValue(labelNode3, "end");
                LabelNode labelNode4 = this.getNew(labelNode3);
                LabelNode labelNode5 = oldTcb.handler;
                Intrinsics.checkNotNullExpressionValue(labelNode5, "handler");
                TryCatchBlockNode newTcb = new TryCatchBlockNode(labelNode2, labelNode4, this.getNew(labelNode5), oldTcb.type);
                newTcb.visibleTypeAnnotations = oldTcb.visibleTypeAnnotations;
                newTcb.invisibleTypeAnnotations = oldTcb.invisibleTypeAnnotations;
                collection.add(newTcb);
            }
            methodNode.tryCatchBlocks = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteLocalVars() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<LocalVariableNode> list = this.methodNode.localVariables;
            Intrinsics.checkNotNullExpressionValue(list, "localVariables");
            Iterable iterable = list;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldVar;
                LocalVariableNode localVariableNode = (LocalVariableNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = oldVar.name;
                String string2 = oldVar.desc;
                String string3 = oldVar.signature;
                LabelNode labelNode = oldVar.start;
                Intrinsics.checkNotNullExpressionValue(labelNode, "start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldVar.end;
                Intrinsics.checkNotNullExpressionValue(labelNode3, "end");
                collection.add(new LocalVariableNode(string, string2, string3, labelNode2, this.getNew(labelNode3), oldVar.index));
            }
            methodNode.localVariables = (List)destination$iv$iv;
        }

        private final AbstractInsnNode rewriteLabels(LineNumberNode $this$rewriteLabels) {
            int n2 = $this$rewriteLabels.line;
            LabelNode labelNode = $this$rewriteLabels.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "start");
            return new LineNumberNode(n2, this.getNewOrOld(labelNode));
        }

        private final AbstractInsnNode rewriteLabels(JumpInsnNode $this$rewriteLabels) {
            int n2 = $this$rewriteLabels.getOpcode();
            LabelNode labelNode = $this$rewriteLabels.label;
            Intrinsics.checkNotNullExpressionValue(labelNode, "label");
            return new JumpInsnNode(n2, this.getNew(labelNode));
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(LookupSwitchInsnNode $this$rewriteLabels) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LabelNode labelNode = $this$rewriteLabels.dflt;
            Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
            LabelNode labelNode2 = this.getNew(labelNode);
            List<Integer> list = $this$rewriteLabels.keys;
            Intrinsics.checkNotNullExpressionValue(list, "keys");
            LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(labelNode2, CollectionsKt.toIntArray((Collection<Integer>)list), new LabelNode[0]);
            List<LabelNode> list2 = $this$rewriteLabels.labels;
            Intrinsics.checkNotNullExpressionValue(list2, "labels");
            Iterable iterable = list2;
            LookupSwitchInsnNode lookupSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode3 = (LabelNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection.add(this.getNew((LabelNode)it));
            }
            lookupSwitchInsnNode.labels = (List)destination$iv$iv;
            return switchNode;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(TableSwitchInsnNode $this$rewriteLabels) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n2 = $this$rewriteLabels.min;
            int n3 = $this$rewriteLabels.max;
            LabelNode labelNode = $this$rewriteLabels.dflt;
            Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
            TableSwitchInsnNode switchNode = new TableSwitchInsnNode(n2, n3, this.getNew(labelNode), new LabelNode[0]);
            List<LabelNode> list = $this$rewriteLabels.labels;
            Intrinsics.checkNotNullExpressionValue(list, "labels");
            Iterable iterable = list;
            TableSwitchInsnNode tableSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode2 = (LabelNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection.add(this.getNew((LabelNode)it));
            }
            tableSwitchInsnNode.labels = (List)destination$iv$iv;
            return switchNode;
        }

        private final AbstractInsnNode rewriteLabels(FrameNode $this$rewriteLabels) {
            Object it;
            Collection collection;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            FrameNode frameNode = new FrameNode($this$rewriteLabels.type, 0, new Object[0], 0, new Object[0]);
            List<Object> list = $this$rewriteLabels.local;
            Intrinsics.checkNotNullExpressionValue(list, "local");
            Iterable iterable = list;
            FrameNode frameNode2 = frameNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it);
            }
            frameNode2.local = (List)destination$iv$iv;
            List<Object> list2 = $this$rewriteLabels.stack;
            Intrinsics.checkNotNullExpressionValue(list2, "stack");
            $this$map$iv = list2;
            frameNode2 = frameNode;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it);
            }
            frameNode2.stack = (List)destination$iv$iv;
            return frameNode;
        }

        private final LabelNode getNew(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode);
            if (labelNode == null) {
                throw new IllegalStateException("Label wasn't found during iterating through instructions");
            }
            return labelNode;
        }

        private final LabelNode getNewOrOld(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode);
            if (labelNode == null) {
                labelNode = oldLabelNode;
            }
            return labelNode;
        }
    }
}

