# Copyright (C) 2025 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

import names


def main():
    attachToApplication("calqlatr")

    # Digit buttons
    button0 = waitForObjectExists(names.digitButton0)
    button1 = waitForObjectExists(names.digitButton1)
    button2 = waitForObjectExists(names.digitButton2)
    button3 = waitForObjectExists(names.digitButton3)
    button4 = waitForObjectExists(names.digitButton4)
    button5 = waitForObjectExists(names.digitButton5)
    button6 = waitForObjectExists(names.digitButton6)
    button7 = waitForObjectExists(names.digitButton7)
    button8 = waitForObjectExists(names.digitButton8)
    button9 = waitForObjectExists(names.digitButton9)
    decimal = waitForObjectExists(names.decimal)

    # Main operations
    backspace = waitForObjectExists(names.backspaceButton)
    allClear = waitForObjectExists(names.allClearButton)
    plusMinus = waitForObjectExists(names.plusMinusButton)
    equals = waitForObjectExists(names.equalsButton)
    division = waitForObjectExists(names.divisionButton)
    multiplication = waitForObjectExists(names.multiplicationButton)
    plus = waitForObjectExists(names.plusButton)
    minus = waitForObjectExists(names.minusButton)

    test.log("Test that Zero button is visible")
    test.compare(button0.visible, True)
    test.log("Test that Zero button has text '0'")
    test.compare(button0.text, "0")
    test.log("Test that One button is visible")
    test.compare(button1.visible, True)
    test.log("Test that One button has text '1'")
    test.compare(button1.text, "1")
    test.log("Test that Two button is visible")
    test.compare(button2.visible, True)
    test.log("Test that Two button has text '2'")
    test.compare(button2.text, "2")
    test.log("Test that Three button is visible")
    test.compare(button3.visible, True)
    test.log("Test that Three button has text '3'")
    test.compare(button3.text, "3")
    test.log("Test that Four button is visible")
    test.compare(button4.visible, True)
    test.log("Test that Four button has text '4'")
    test.compare(button4.text, "4")
    test.log("Test that Five button is visible")
    test.compare(button5.visible, True)
    test.log("Test that Five button has text '5'")
    test.compare(button5.text, "5")
    test.log("Test that Six button is visible")
    test.compare(button6.visible, True)
    test.log("Test that Six button has text '6'")
    test.compare(button6.text, "6")
    test.log("Test that Seven button is visible")
    test.compare(button7.visible, True)
    test.log("Test that Seven button has text '7'")
    test.compare(button7.text, "7")
    test.log("Test that Eight button is visible")
    test.compare(button8.visible, True)
    test.log("Test that Eight button has text '8'")
    test.compare(button8.text, "8")
    test.log("Test that Nine button is visible")
    test.compare(button9.visible, True)
    test.log("Test that Nine button has text '9'")
    test.compare(button9.text, "9")
    test.log("Test that Decimal button is visible")
    test.compare(decimal.visible, True)
    test.log("Test that Decimal button has text '.'")
    test.compare(decimal.text, ".")

    test.log("Test that Backspace button is visible")
    test.compare(backspace.visible, True)
    test.log("Test that All Clear button is visible")
    test.compare(allClear.visible, True)
    test.log("Test that All Clear button has text 'AC'")
    test.compare(allClear.text, "AC")
    test.log("Test that PlusMinus button is visible")
    test.compare(plusMinus.visible, True)
    test.log("Test that PlusMinus button has text '±'")
    test.compare(plusMinus.text, "±")
    test.log("Test that Equals button is visible")
    test.compare(equals.visible, True)
    test.log("Test that Equals button has text '='")
    test.compare(equals.text, "=")
    test.log("Test that Division button is visible")
    test.compare(division.visible, True)
    test.log("Test that Division button has text '÷'")
    test.compare(division.text, "÷")
    test.log("Test that Multiplication button is visible")
    test.compare(multiplication.visible, True)
    test.log("Test that Multiplication button has text '×'")
    test.compare(multiplication.text, "×")
    test.log("Test that Plus button is visible")
    test.compare(plus.visible, True)
    test.log("Test that Plus button has text '+'")
    test.compare(plus.text, "+")
    test.log("Test that Minus button is visible")
    test.compare(minus.visible, True)
    test.log("Test that Minus button has text '−'")
    test.compare(minus.text, "−")

    if waitForObjectExists(names.landscapeMode).visible:
        test.log("Landscape mode extra tests")

        # Scientific Digit buttons
        euler = waitForObjectExists(names.digitButtonEuler)
        pi = waitForObjectExists(names.digitButtonPi)

        # Scientific operations
        squaring = waitForObjectExists(names.squaringButton)
        denominator = waitForObjectExists(names.denominatorButton)
        squareroot = waitForObjectExists(names.squareRootButton)
        cubed = waitForObjectExists(names.cubedButton)
        sin = waitForObjectExists(names.sinButton)
        absvalue = waitForObjectExists(names.absValueButton)
        logarithm = waitForObjectExists(names.logarithmButton)
        cos = waitForObjectExists(names.cosButton)
        naturalogarithm = waitForObjectExists(names.naturalLogarithmButton)
        tan = waitForObjectExists(names.tanButton)

        test.log("Test that Euler e button is visible")
        test.compare(euler.visible, True)
        test.log("Test that Euler e button has text 'e'")
        test.compare(euler.text, "e")
        test.log("Test that PI button is visible")
        test.compare(pi.visible, True)
        test.log("Test that PI button has text 'π'")
        test.compare(pi.text, "π")

        test.log("Test that Squared button is visible")
        test.compare(squaring.visible, True)
        test.log("Test that Squared button has text 'x²'")
        test.compare(squaring.text, "x²")
        test.log("Test that Denominator button is visible")
        test.compare(denominator.visible, True)
        test.log("Test that Denominator Root button has text '⅟x'")
        test.compare(denominator.text, "⅟x")
        test.log("Test that Square Root button is visible")
        test.compare(squareroot.visible, True)
        test.log("Test that Square Root button has text '√'")
        test.compare(squareroot.text, "√")
        test.log("Test that Cubed button is visible")
        test.compare(cubed.visible, True)
        test.log("Test that Cubed button has text 'x³'")
        test.compare(cubed.text, "x³")
        test.log("Test that Sine button is visible")
        test.compare(sin.visible, True)
        test.log("Test that Sine button has text 'sin'")
        test.compare(sin.text, "sin")
        test.log("Test that Absolute Value button is visible")
        test.compare(absvalue.visible, True)
        test.log("Test that Absolute Value button has text '|x|'")
        test.compare(absvalue.text, "|x|")
        test.log("Test that Logarithm button is visible")
        test.compare(logarithm.visible, True)
        test.log("Test that Logarithm button has text 'log'")
        test.compare(logarithm.text, "log")
        test.log("Test that Cosine button is visible")
        test.compare(cos.visible, True)
        test.log("Test that Cosine button has text 'cos'")
        test.compare(cos.text, "cos")
        test.log("Test that Natural Logarithm button is visible")
        test.compare(naturalogarithm.visible, True)
        test.log("Test that Natural Logarithm button has text 'ln'")
        test.compare(naturalogarithm.text, "ln")
        test.log("Test that Tangent button is visible")
        test.compare(tan.visible, True)
        test.log("Test that Tangent button has text 'tan'")
        test.compare(tan.text, "tan")
