/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple.DefaultCompositeExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAnyOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultExcludeAnyOf
extends DefaultCompositeExclude
implements ExcludeAnyOf {
    private Boolean mayExcludeArtifacts;

    public static ExcludeSpec of(ImmutableSet<ExcludeSpec> components) {
        return new DefaultExcludeAnyOf(components);
    }

    private DefaultExcludeAnyOf(ImmutableSet<ExcludeSpec> components) {
        super(components);
    }

    @Override
    int mask() {
        return 1731217984;
    }

    @Override
    protected String getDisplayName() {
        return "any of";
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        for (ExcludeSpec component : this.getComponents()) {
            if (!component.excludes(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        for (ExcludeSpec component : this.getComponents()) {
            if (!component.excludesArtifact(module, artifactName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        if (this.mayExcludeArtifacts != null) {
            return this.mayExcludeArtifacts;
        }
        this.mayExcludeArtifacts = false;
        for (ExcludeSpec component : this.getComponents()) {
            if (!component.mayExcludeArtifacts()) continue;
            this.mayExcludeArtifacts = true;
            break;
        }
        return this.mayExcludeArtifacts;
    }
}

