/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import org.apache.ftpserver.util.OS;

public class IoUtils {
    private static final Random RANDOM_GEN = new Random(System.currentTimeMillis());

    private IoUtils() {
    }

    public static final BufferedInputStream getBufferedInputStream(InputStream in) {
        BufferedInputStream bin = null;
        bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        return bin;
    }

    public static final BufferedOutputStream getBufferedOutputStream(OutputStream out) {
        BufferedOutputStream bout = null;
        bout = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
        return bout;
    }

    public static final BufferedReader getBufferedReader(Reader reader) {
        BufferedReader buffered = null;
        buffered = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return buffered;
    }

    public static final BufferedWriter getBufferedWriter(Writer wr) {
        BufferedWriter bw = null;
        bw = wr instanceof BufferedWriter ? (BufferedWriter)wr : new BufferedWriter(wr);
        return bw;
    }

    public static final File getUniqueFile(File oldFile) {
        File newFile = oldFile;
        while (newFile.exists()) {
            newFile = new File(oldFile.getAbsolutePath() + '.' + Math.abs(RANDOM_GEN.nextLong()));
        }
        return newFile;
    }

    public static final void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void close(Reader rd) {
        if (rd != null) {
            try {
                rd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void close(Writer wr) {
        if (wr != null) {
            try {
                wr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final String getStackTrace(Throwable ex) {
        String result = "";
        if (ex != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.close();
                sw.close();
                result = sw.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static final void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    public static final void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    public static final String readFully(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IoUtils.copy(reader, writer, 1024);
        return writer.toString();
    }

    public static final String readFully(InputStream input) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader(input);
        IoUtils.copy(reader, writer, 1024);
        return writer.toString();
    }

    public static final void delete(File file) throws IOException {
        if (file.isDirectory()) {
            IoUtils.deleteDir(file);
        } else {
            IoUtils.deleteFile(file);
        }
    }

    private static void deleteDir(File dir) throws IOException {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            File file = children[i];
            IoUtils.delete(file);
        }
        if (!dir.delete()) {
            throw new IOException("Failed to delete directory: " + dir);
        }
    }

    private static void deleteFile(File file) throws IOException {
        if (!file.delete()) {
            if (OS.isFamilyWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!file.delete()) {
                throw new IOException("Failed to delete file: " + file);
            }
        }
    }
}

