/**CHeaderFile*************************************************************
  PackageName [Bdd Scout]
  Synopsis    [Bdd Scout]

  FileName    [bddscout.h]
  Revision    [$Revision: 13 $]
  Date        [$Date: 2010-07-22 13:17:11 +0200 (Thu, 22 Jul 2010) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [The file bddscout.h contains some declarations.]
  SeeAlso     []

  Copyright   [This file is part of Bdd Scout package.
               Copyright (C) 2008, 2009, 2010 UM-FERI
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               Bdd Scout is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               Bdd Scout is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifndef _BDDSCOUT
#define _BDDSCOUT

#include <biddy.h>
#include <tcl.h>

#if TCL_MAJOR_VERSION < 8
#  error "We need Tcl 8.1 or greater to build this"
#elif defined(USE_TCL_STUBS) && TCL_MAJOR_VERSION == 8 && \
   (TCL_MINOR_VERSION == 0 || \
   (TCL_MINOR_VERSION == 1 && TCL_RELEASE_LEVEL != TCL_FINAL_RELEASE))
#   error "Stubs interface doesn't work in 8.0 and alpha/beta 8.1"
#endif

/* ON WIN32 THERE HAS TO BE DEFINED WIN32 */
/* ON UNIX THERE HAS TO BE DEFINED UNIX */
/* ON MACOSX THERE HAS TO BE DEFINED MACOSX */

#ifdef UNIX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

#ifdef WIN32
#ifndef TCL
#    ifdef BUILD_BDDSCOUT
#      undef EXTERN
#      define EXTERN __declspec (dllexport)
#    else
#      ifdef USE_BDDSCOUT
#        undef EXTERN
#        define EXTERN __declspec (dllimport)
#      else
#        define EXTERN extern
#      endif
#    endif
#else
#    ifdef BUILD_BDDSCOUT
#      undef TCL_STORAGE_CLASS
#      define TCL_STORAGE_CLASS DLLEXPORT
#    else
#      undef TCL_STORAGE_CLASS
#      define TCL_STORAGE_CLASS DLLIMPORT
#    endif
#endif
#endif

#ifdef MACOSX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

/*-----------------------------------------------------------------------*/
/* Constant definitions                                                  */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Macro definitions                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Type declarations                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Function prototypes                                                   */
/*-----------------------------------------------------------------------*/

EXTERN Biddy_Boolean Bddscout_FindFormula(Biddy_String x, Biddy_Edge *f);

EXTERN void Bddscout_AddFormula(Biddy_String x, Biddy_Edge f);

EXTERN Biddy_Edge Bddscout_ParseString(Biddy_String s);

/**AutomaticEnd***********************************************************/

#endif  /* _BDDSCOUT */
