@echo off

REM  Author: Robert Meolic (meolic@uni-mb.si)
REM  $Revision: 30 $
REM  $Date: 2010-07-22 15:57:47 +0200 (Thu, 22 Jul 2010) $
REM
REM  This file is part of Biddy.
REM  Copyright (C) 2006, 2007, 2008, 2009, 2010 UM-FERI
REM  UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
REM
REM  Biddy is free software; you can redistribute it and/or modify
REM  it under the terms of the GNU General Public License as
REM  published by the Free Software Foundation; either version 2
REM  of the License, or (at your option) any later version.
REM
REM  Biddy is distributed in the hope that it will be useful,
REM  but WITHOUT ANY WARRANTY; without even the implied warranty of
REM  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
REM  GNU General Public License for more details.
REM
REM  You should have received a copy of the GNU General Public
REM  License along with this program; if not, write to the Free
REM  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
REM  Boston, MA 02110-1301 USA.]

SET NAME=biddy
FOR /F "USEBACKQ" %%T IN (`TYPE VERSION`) DO SET VVERSION=%%T
SET VERSION=%VVERSION:.=-%
SET MYZIP=N:\info-zip\zip.exe -o -q
SET MAKESFX=N:\FreeExtractor\MakeSFX.exe

rm -f %NAME%-bin-%VERSION%-Win.zip
rm -f %NAME%-%VERSION%-Win.zip

rm -fr .\%NAME%-%VERSION%

make dynamic "BINDIR = ../biddy/%NAME%-%VERSION%"
make clean "BINDIR = ../biddy/%NAME%-%VERSION%"

cp COPYING ./%NAME%-%VERSION%/
cp CHANGES ./%NAME%-%VERSION%/CHANGES
cp biddy.h ./%NAME%-%VERSION%/

echo "Creating %NAME%-bin-%VERSION%-Win.zip ..."
%MYZIP% %NAME%-bin-%VERSION%-Win.zip .\%NAME%-%VERSION%\* -x .\%NAME%-%VERSION%\biddy.h

%MAKESFX% /zip="%NAME%-bin-%VERSION%-Win.zip" /sfx="%NAME%-bin-%VERSION%-Win.exe" /title="Biddy (binary version)" /website="http://lms.uni-mb.si/biddy/" /intro="Version %VVERSION%\n\nBiddy is a multi-platform academic Binary Decision Diagrams package.\n\nThis is free software. See GNU GPL (version 2).\n\nFreeExtractor Wizard will extract files into the target folder.\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" /defaultpath="C:\Program Files\biddy" /overwrite

echo "Creating %NAME%-%VERSION%-Win.zip ..."

%MYZIP% %NAME%-%VERSION%-Win.zip .\%NAME%-%VERSION%\*

%MAKESFX% /zip="%NAME%-%VERSION%-Win.zip" /sfx="%NAME%-%VERSION%-Win.exe" /title="Biddy (development version)" /website="http://lms.uni-mb.si/biddy/" /intro="Version %VVERSION%\n\nBiddy is a multi-platform academic Binary Decision Diagrams package.\n\nThis is free software. See GNU GPL (version 2).\n\nFreeExtractor Wizard will extract files into the target folder.\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" /defaultpath="C:\Program Files\biddy" /overwrite

rm -fr .\%NAME%-%VERSION%
rm -f %NAME%-bin-%VERSION%-Win.zip
rm -f %NAME%-%VERSION%-Win.zip

echo *******************
echo PACKAGES COMPLETED!
echo *******************
